
  /*
   *  Object %name    : %
   *  State           :  %state%
   *  Creation date   :  Sun Feb 20 12:11:20 2005
   *  Last modified   :  %modify_time%
   */
  /** @file
   *  \brief A brief description of this module
   *
   *  \version CRYS_ATP_TST_DH_MAIN.c#1:csrc:1
   *  \author doronp
   *  \remarks Copyright (C) 2007 by Discretix Technologies Ltd.
   *           All Rights reserved
   */
/* disabling pc lint warning regarding to constant condition :
   'Constant value Boolean' */
/*lint --e{506} */

/***** Include Files ******/
#include "CRYS.h"

#include "CRYS_ATP_TST_Defines.h"
#include "CRYS_ATP_TST_UTIL_Funcs.h"
#include "CRYS_ATP_TST_DH_Acceptance.h"

#include <stdio.h>
#if TST_USE_DH_DATA/*In case no test vectors are selected - code disabled*/
/******** Defines *********/
/******** Enums *********/
/******** Typedefs ********/
/******** Global Data *******/
/***** Private function prototype *****/
CRYSError_t CRYS_ATP_TST_DH_Acceptance_ALL_TESTS(void);


/******** Public Functions **********/
void CRYS_ATP_TST_DH_main(void)
{
  DxUint8_t  Var;
 
  do
   {  
     do
     {
             ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"\n\n\n--[ DH tests Menu ]-------------------"));
             ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"\n [1] - PKCS#3 key agreament               "));
             ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"\n [2] - ANSI 9.42 key agreament            "));
         #if TST_DH_DOMAIN_PARAMETERS_SUPPORTED
             ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"\n [3] - ANSI 9.42 domain parameters generation "));
         #endif
             ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"\n [T] - ALL DH Acceptance tests            "));
             ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"\n [Z] - End of tests return to prev menu   "));
             ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"\n---------------------------------------\n\n"));
             scanf("\n%c",&Var);
             ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"\n Test = %c\n",Var));
             if (Var<='Z')
                      break;
             else
             {
                   ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"\n Error[%d]  Please select '1'-'XX'\n\n",Var));
             }

      }while(1);

     
      switch(Var)
      {
        case '1': 
            CRYS_ATP_TST_DH_Acceptance_PKCS3();
            break;
        case '2':             
            CRYS_ATP_TST_DH_Acceptance_ANSI942();
            break;            
        case '3':
          #if TST_DH_DOMAIN_PARAMETERS_SUPPORTED
          CRYS_ATP_TST_DH_DomainParametersGeneration_Acceptance_ANSI942();
          break;
          #endif            
        case 'T': 
            CRYS_ATP_TST_DH_Acceptance_ALL_TESTS();
            break;                
        case 'Z':
            ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"\n End of DES tests \n"));
            break ;
                
        default:
            ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"\n* Error in test selection [%c]\n",Var));
      }
         if(Var =='Z')
         break;       
     }while (1);
}


/******** Private Functions **********/
/***************************
 * Function Name:
 *   CRYS_ATP_TST_DH_Acceptance_ALL_TESTS
 *
 * Inputs:
 *   none 
 *
 * Outputs:
 *   CRYSError_t - Function error return
 *
 * Description:
 * This function runs all of the DH Acceptance tests 
 *
 **************************/
CRYSError_t CRYS_ATP_TST_DH_Acceptance_ALL_TESTS(void)
{
    CRYSError_t        TST_Status = TESTPASS ,TST_TestStatus = TESTPASS;
    DxUint8_t          TST_DebugStatus = ATP_EXIT_TEST_AFTER_FAILURE;  

    TST_TestStatus = CRYS_ATP_TST_DH_Acceptance_PKCS3();
    TST_Status = TST_Status+TST_TestStatus;

    if (TST_DebugStatus == NO_DEBUG)
    {
      if (TST_Status != TESTPASS)
          goto EXIT_ON_ERROR;
    }

    TST_TestStatus = CRYS_ATP_TST_DH_Acceptance_ANSI942();
    TST_Status = TST_Status+TST_TestStatus;

    if (TST_DebugStatus == NO_DEBUG)
    {
      if (TST_Status != TESTPASS)
         goto EXIT_ON_ERROR;
    }

  #if TST_DH_DOMAIN_PARAMETERS_SUPPORTED
  TST_TestStatus = CRYS_ATP_TST_DH_DomainParametersGeneration_Acceptance_ANSI942();
  #endif
  TST_Status = TST_Status+TST_TestStatus;

    if (TST_DebugStatus == NO_DEBUG)
    {
      if (TST_Status != TESTPASS)
         goto EXIT_ON_ERROR;
    }

    ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"\n \n**********************\n"));
    ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"**********************\n"));
    ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"*** ALL OF THE DH Acceptance TESTS PASS    :-)         ***\n"));
    ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"**********************\n"));
    ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"**********************\n"));   

    return TST_Status;

EXIT_ON_ERROR:

      ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"\n\n!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!\n"));
      ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"!!!!!!!!! ONE OR MORE OF THE DH TESTS FAILED !!!!!!!!!!!!!!!!!!!!!\n"));
      ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!\n"));

     return DX_FAILURE;;

}

#endif
